//
//  MCStackListView.h
//  MCApplication
//
//  Created by Ali Lalani on 8/30/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCStackBackgroundColorView.h"
#import "MCTableView.h"

#import "MCStackTabbedPaneTabProtocol.h"
#import "MCDisplayStateProtocol.h"

#import <MCFoundation/MCFoundationDefines.h>

@class MCSearchField;

@interface MCStackListView : MCStackBackgroundColorView <MCStackTabbedPaneTab,MCDisplayState> {
	id parentController;
	
	IBOutlet id resultsTable;

	NSString *columnSubsetIdentifier;
	NSString *columnGroupIdentifier;
	NSString *columnConfigurationIdentifier;

	IBOutlet MCSearchField *searchField;

	NSMutableDictionary *displayState;
	id                   displayStateDelegate;

	id document;
}
//- (void)updateForNewSortDescriptors;
- (id)activeResultsTable;

// YES by default, overriders can implement to stop column options from being visible
- (BOOL)allowsColumnOptions;

//////////////////////////////// ACCESSORS ////////////////////////////////
#pragma mark Accessors
- (void)setParentController:(id)aParentController;
- (id)parentController;

- (NSString *)columnSubsetIdentifier;
- (void)setColumnSubsetIdentifier:(NSString *)aColumnSubsetIdentifier;

- (NSString *)columnGroupIdentifier;
- (void)setColumnGroupIdentifier:(NSString *)aColumnGroupIdentifier;

- (NSString *)columnConfigurationIdentifier;
- (void)setColumnConfigurationIdentifier:(NSString *)aColumnConfigurationIdentifier;

- (id)document;
- (void)setDocument:(id)aDocument;

#pragma mark TabularExport
- (void)exportTabularDataForSelectedRowsToFile:(NSString *)aFile format:(unsigned)format encoding:(NSStringEncoding)encoding lineEndingType:(MCLineEndingType)lineEndingType;
- (IBAction)exportTabularDataForSelectedRows:(id)sender;
- (NSString *)tabularStringForObject:(id)anObj;
- (NSString *)tabularStringWithSelectedRows;
- (void)exportTabularDataForSelectedRowsToFile:(NSString *)aFile;
- (IBAction)copy:(id)sender;

#pragma mark DisplayStateReadWrite
@end
